//
//  Copyright © 2025 Kyle Hughes. All rights reserved.
//  SPDX-License-Identifier: MIT
//

import Synchronization

@available(macOS 15.0, iOS 18.0, tvOS 18.0, watchOS 11.0, *)
final class SendableRecorder: Sendable {
    // MARK: Internal Instance Properties
    
    var last: String? {
        mutex.withLock { $0 }
    }
    
    // MARK: Private Instance Properties
    
    private let mutex: Mutex<String?>
    
    // MARK: Internal Initialization
    
    init(last: String? = nil) {
        mutex = Mutex(last)
    }
    
    // MARK: Internal Instance Interface
    
    func record(_ text: String) {
        mutex.withLock {
            $0 = text
        }
    }
}
